shape = {}

function shape.Calculate()
   local c = sc.Coord2D(0,0)
   Line(shape.chamfer, 0, shape.width, 0)
   local ang = (math.pi / 2) - shape.angle
   e = c:ArcPoint(ang, shape.height)
   LineTo(e.x, e.y)
   e = c:ArcPoint(ang, shape.chamfer)
   LineTo(e.x, e.y)
   LineTo(shape.chamfer, 0)   
end

AddNumControl("width", "Width", sc.unitLINEAR, 100, 0.1, 10000, "width.png")
AddNumControl("height", "Height", sc.unitLINEAR, 100, 0.1, 10000, "height.png")
AddNumControl("angle", "Angle", sc.unitANGULAR, math.pi / 2, 0.1, 3, "angle.png")
AddNumControl("chamfer", "Corner chamfer", sc.unitLINEAR, 10, 0, 10000, "chamfer.png")
